// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Insslopenssl.pas' rev: 10.00

#ifndef InsslopensslHPP
#define InsslopensslHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Instackconsts.hpp>	// Pascal unit
#include <Insockethandle.hpp>	// Pascal unit
#include <Insslopensslheaders.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Iniohandler.hpp>	// Pascal unit
#include <Inglobalprotocols.hpp>	// Pascal unit
#include <Intcpserver.hpp>	// Pascal unit
#include <Inthread.hpp>	// Pascal unit
#include <Intcpconnection.hpp>	// Pascal unit
#include <Inintercept.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Iniohandlersocket.hpp>	// Pascal unit
#include <Inssl.hpp>	// Pascal unit
#include <Insocks.hpp>	// Pascal unit
#include <Inscheduler.hpp>	// Pascal unit
#include <Inyarn.hpp>	// Pascal unit
#include <Iniohandlerstack.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit
#include <Inserveriohandler.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Insslopenssl
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TInSSLVersion { sslvSSLv2, sslvSSLv23, sslvSSLv3, sslvTLSv1 };
#pragma option pop

#pragma option push -b-
enum TInSSLMode { sslmUnassigned, sslmClient, sslmServer, sslmBoth };
#pragma option pop

#pragma option push -b-
enum TInSSLVerifyMode { sslvrfPeer, sslvrfFailIfNoPeerCert, sslvrfClientOnce };
#pragma option pop

typedef Set<TInSSLVerifyMode, sslvrfPeer, sslvrfClientOnce>  TInSSLVerifyModeSet;

#pragma option push -b-
enum TInSSLCtxMode { sslCtxClient, sslCtxServer };
#pragma option pop

#pragma option push -b-
enum TInSSLAction { sslRead, sslWrite };
#pragma option pop

#pragma pack(push,1)
struct TULong
{
	
	union
	{
		struct 
		{
			unsigned C1;
			
		};
		struct 
		{
			int L1;
			
		};
		struct 
		{
			Word W1;
			Word W2;
			
		};
		struct 
		{
			Byte B1;
			Byte B2;
			Byte B3;
			Byte B4;
			
		};
		
	};
} ;
#pragma pack(pop)

struct TEVP_MD
{
	
public:
	int Length;
	char MD[36];
} ;

struct TByteArray
{
	
public:
	int Length;
	char *Data;
} ;

typedef void __fastcall (__closure *TCallbackEvent)(AnsiString Msg);

typedef void __fastcall (__closure *TPasswordEvent)(AnsiString &Password);

class DELPHICLASS TIdX509;
typedef bool __fastcall (__closure *TVerifyPeerEvent)(TIdX509* Certificate);

class DELPHICLASS TInSSLIOHandlerSocketOpenSSL;
typedef void __fastcall (__closure *TIOHandlerNotify)(TInSSLIOHandlerSocketOpenSSL* ASender);

class DELPHICLASS TInSSLOptions;
class PASCALIMPLEMENTATION TInSSLOptions : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
protected:
	AnsiString fsRootCertFile;
	AnsiString fsCertFile;
	AnsiString fsKeyFile;
	TInSSLVersion fMethod;
	TInSSLMode fMode;
	int fVerifyDepth;
	TInSSLVerifyModeSet fVerifyMode;
	AnsiString fVerifyDirs;
	AnsiString fCipherList;
	virtual void __fastcall AssignTo(Classes::TPersistent* ASource);
	
__published:
	__property AnsiString RootCertFile = {read=fsRootCertFile, write=fsRootCertFile};
	__property AnsiString CertFile = {read=fsCertFile, write=fsCertFile};
	__property AnsiString KeyFile = {read=fsKeyFile, write=fsKeyFile};
	__property TInSSLVersion Method = {read=fMethod, write=fMethod, nodefault};
	__property TInSSLMode Mode = {read=fMode, write=fMode, nodefault};
	__property TInSSLVerifyModeSet VerifyMode = {read=fVerifyMode, write=fVerifyMode, nodefault};
	__property int VerifyDepth = {read=fVerifyDepth, write=fVerifyDepth, nodefault};
	__property AnsiString VerifyDirs = {read=fVerifyDirs, write=fVerifyDirs};
	__property AnsiString CipherList = {read=fCipherList, write=fCipherList};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TInSSLOptions(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TInSSLOptions(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


class DELPHICLASS TInSSLContext;
class PASCALIMPLEMENTATION TInSSLContext : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	TInSSLVersion fMethod;
	TInSSLMode fMode;
	AnsiString fsRootCertFile;
	AnsiString fsCertFile;
	AnsiString fsKeyFile;
	int fVerifyDepth;
	TInSSLVerifyModeSet fVerifyMode;
	AnsiString fVerifyDirs;
	AnsiString fCipherList;
	void *fContext;
	bool fStatusInfoOn;
	bool fVerifyOn;
	int fSessionId;
	TInSSLCtxMode fCtxMode;
	void __fastcall DestroyContext(void);
	void * __fastcall SetSSLMethod(void);
	void __fastcall SetVerifyMode(TInSSLVerifyModeSet Mode, bool CheckRoutine);
	TInSSLVerifyModeSet __fastcall GetVerifyMode(void);
	void __fastcall InitContext(TInSSLCtxMode CtxMode);
	
public:
	System::TObject* Parent;
	__fastcall TInSSLContext(void);
	__fastcall virtual ~TInSSLContext(void);
	TInSSLContext* __fastcall Clone(void);
	bool __fastcall LoadRootCert(void);
	bool __fastcall LoadCert(void);
	bool __fastcall LoadKey(void);
	__property bool StatusInfoOn = {read=fStatusInfoOn, write=fStatusInfoOn, nodefault};
	__property bool VerifyOn = {read=fVerifyOn, write=fVerifyOn, nodefault};
	
__published:
	__property TInSSLVersion Method = {read=fMethod, write=fMethod, nodefault};
	__property TInSSLMode Mode = {read=fMode, write=fMode, nodefault};
	__property AnsiString RootCertFile = {read=fsRootCertFile, write=fsRootCertFile};
	__property AnsiString CertFile = {read=fsCertFile, write=fsCertFile};
	__property AnsiString KeyFile = {read=fsKeyFile, write=fsKeyFile};
	__property TInSSLVerifyModeSet VerifyMode = {read=fVerifyMode, write=fVerifyMode, nodefault};
	__property int VerifyDepth = {read=fVerifyDepth, write=fVerifyDepth, nodefault};
};


class DELPHICLASS TInSSLSocket;
class DELPHICLASS TInSSLCipher;
class PASCALIMPLEMENTATION TInSSLCipher : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TInSSLSocket* FSSLSocket;
	AnsiString __fastcall GetDescription();
	AnsiString __fastcall GetName();
	int __fastcall GetBits(void);
	AnsiString __fastcall GetVersion();
	
public:
	__fastcall TInSSLCipher(TInSSLSocket* AOwner);
	__fastcall virtual ~TInSSLCipher(void);
	
__published:
	__property AnsiString Description = {read=GetDescription};
	__property AnsiString Name = {read=GetName};
	__property int Bits = {read=GetBits, nodefault};
	__property AnsiString Version = {read=GetVersion};
};


class PASCALIMPLEMENTATION TInSSLSocket : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TIdX509* fPeerCert;
	TInSSLCipher* fSSLCipher;
	System::TObject* fParent;
	TInSSLContext* fSSLContext;
	TIdX509* __fastcall GetPeerCert(void);
	int __fastcall GetSSLError(int retCode);
	TInSSLCipher* __fastcall GetSSLCipher(void);
	
public:
	void *fSSL;
	__fastcall TInSSLSocket(System::TObject* Parent);
	void __fastcall Accept(const int pHandle, TInSSLContext* fSSLContext);
	void __fastcall Connect(const int pHandle, TInSSLContext* fSSLContext);
	int __fastcall Send(const Inglobal::TBytes ABuf);
	int __fastcall Recv(Inglobal::TBytes &ABuf);
	__fastcall virtual ~TInSSLSocket(void);
	TByteArray __fastcall GetSessionID();
	AnsiString __fastcall GetSessionIDAsString();
	void __fastcall SetCipherList(AnsiString CipherList);
	__property TIdX509* PeerCert = {read=GetPeerCert};
	__property TInSSLCipher* Cipher = {read=GetSSLCipher};
};


class PASCALIMPLEMENTATION TInSSLIOHandlerSocketOpenSSL : public Inssl::TInSSLIOHandlerSocketBase 
{
	typedef Inssl::TInSSLIOHandlerSocketBase inherited;
	
private:
	TInSSLContext* fSSLContext;
	TInSSLOptions* fxSSLOptions;
	TInSSLSocket* fSSLSocket;
	TCallbackEvent fOnStatusInfo;
	TPasswordEvent fOnGetPassword;
	TVerifyPeerEvent fOnVerifyPeer;
	bool fSSLLayerClosed;
	TIOHandlerNotify fOnBeforeConnect;
	
protected:
	virtual void __fastcall SetPassThrough(const bool Value);
	virtual void __fastcall DoBeforeConnect(TInSSLIOHandlerSocketOpenSSL* ASender);
	virtual void __fastcall DoStatusInfo(AnsiString Msg);
	virtual void __fastcall DoGetPassword(AnsiString &Password);
	virtual bool __fastcall DoVerifyPeer(TIdX509* Certificate);
	virtual int __fastcall RecvEnc(Inglobal::TBytes &ABuf);
	virtual int __fastcall SendEnc(const Inglobal::TBytes ABuf);
	void __fastcall Init(void);
	virtual void __fastcall OpenEncodedConnection(void);
	virtual void __fastcall InitComponent(void);
	virtual void __fastcall ConnectClient(void);
	virtual int __fastcall ReadFromSource(bool ARaiseExceptionIfDisconnected = true, int ATimeout = 0xffffffff, bool ARaiseExceptionOnTimeout = true);
	
public:
	virtual void __fastcall WriteDirect(Inglobal::TBytes ABuffer);
	__fastcall virtual ~TInSSLIOHandlerSocketOpenSSL(void);
	virtual Inssl::TInSSLIOHandlerSocketBase* __fastcall Clone(void);
	virtual void __fastcall StartSSL(void);
	virtual void __fastcall AfterAccept(void);
	virtual void __fastcall Close(void);
	virtual void __fastcall Open(void);
	int __fastcall Recv(Inglobal::TBytes &ABuf);
	int __fastcall Send(const Inglobal::TBytes ABuf);
	__property TInSSLSocket* SSLSocket = {read=fSSLSocket, write=fSSLSocket};
	__property bool PassThrough = {read=fPassThrough, write=SetPassThrough, nodefault};
	__property TIOHandlerNotify OnBeforeConnect = {read=fOnBeforeConnect, write=fOnBeforeConnect};
	__property TInSSLContext* SSLContext = {read=fSSLContext, write=fSSLContext};
	
__published:
	__property TInSSLOptions* SSLOptions = {read=fxSSLOptions, write=fxSSLOptions};
	__property TCallbackEvent OnStatusInfo = {read=fOnStatusInfo, write=fOnStatusInfo};
	__property TPasswordEvent OnGetPassword = {read=fOnGetPassword, write=fOnGetPassword};
	__property TVerifyPeerEvent OnVerifyPeer = {read=fOnVerifyPeer, write=fOnVerifyPeer};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInSSLIOHandlerSocketOpenSSL(Classes::TComponent* AOwner)/* overload */ : Inssl::TInSSLIOHandlerSocketBase(AOwner) { }
	#pragma option pop
	
};


class DELPHICLASS TInServerIOHandlerSSLOpenSSL;
class PASCALIMPLEMENTATION TInServerIOHandlerSSLOpenSSL : public Inssl::TInServerIOHandlerSSLBase 
{
	typedef Inssl::TInServerIOHandlerSSLBase inherited;
	
private:
	TInSSLContext* fSSLContext;
	TInSSLOptions* fxSSLOptions;
	bool fIsInitialized;
	TCallbackEvent fOnStatusInfo;
	TPasswordEvent fOnGetPassword;
	TVerifyPeerEvent fOnVerifyPeer;
	
protected:
	virtual void __fastcall DoStatusInfo(AnsiString Msg);
	virtual void __fastcall DoGetPassword(AnsiString &Password);
	virtual bool __fastcall DoVerifyPeer(TIdX509* Certificate);
	virtual void __fastcall InitComponent(void);
	
public:
	virtual void __fastcall Init(void);
	virtual Iniohandler::TInIOHandler* __fastcall Accept(Insockethandle::TInSocketHandle* ASocket, Inthread::TInThread* AListenerThread, Inyarn::TInYarn* AYarn);
	__fastcall virtual ~TInServerIOHandlerSSLOpenSSL(void);
	virtual Inssl::TInSSLIOHandlerSocketBase* __fastcall MakeClientIOHandler(void)/* overload */;
	virtual Inssl::TInSSLIOHandlerSocketBase* __fastcall MakeFTPSvrPort(void);
	virtual Inssl::TInSSLIOHandlerSocketBase* __fastcall MakeFTPSvrPasv(void);
	__property TInSSLContext* SSLContext = {read=fSSLContext};
	
__published:
	__property TInSSLOptions* SSLOptions = {read=fxSSLOptions, write=fxSSLOptions};
	__property TCallbackEvent OnStatusInfo = {read=fOnStatusInfo, write=fOnStatusInfo};
	__property TPasswordEvent OnGetPassword = {read=fOnGetPassword, write=fOnGetPassword};
	__property TVerifyPeerEvent OnVerifyPeer = {read=fOnVerifyPeer, write=fOnVerifyPeer};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInServerIOHandlerSSLOpenSSL(Classes::TComponent* AOwner)/* overload */ : Inssl::TInServerIOHandlerSSLBase(AOwner) { }
	#pragma option pop
	
	
/* Hoisted overloads: */
	
public:
	inline Iniohandler::TInIOHandler* __fastcall  MakeClientIOHandler(Inyarn::TInYarn* ATheThread){ return TInServerIOHandlerSSLBase::MakeClientIOHandler(ATheThread); }
	
};


class DELPHICLASS TIdX509Name;
class PASCALIMPLEMENTATION TIdX509Name : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	void *fX509Name;
	AnsiString __fastcall CertInOneLine();
	TULong __fastcall GetHash(void);
	AnsiString __fastcall GetHashAsString();
	
public:
	__fastcall TIdX509Name(void * aX509Name);
	__property TULong Hash = {read=GetHash};
	__property AnsiString HashAsString = {read=GetHashAsString};
	__property AnsiString OneLine = {read=CertInOneLine};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TIdX509Name(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TIdX509 : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	void *FX509;
	TIdX509Name* FSubject;
	TIdX509Name* FIssuer;
	TIdX509Name* __fastcall RSubject(void);
	TIdX509Name* __fastcall RIssuer(void);
	System::TDateTime __fastcall RnotBefore(void);
	System::TDateTime __fastcall RnotAfter(void);
	TEVP_MD __fastcall RFingerprint();
	AnsiString __fastcall RFingerprintAsString();
	
public:
	__fastcall virtual TIdX509(void * aX509);
	__fastcall virtual ~TIdX509(void);
	__property TEVP_MD Fingerprint = {read=RFingerprint};
	__property AnsiString FingerprintAsString = {read=RFingerprintAsString};
	__property TIdX509Name* Subject = {read=RSubject};
	__property TIdX509Name* Issuer = {read=RIssuer};
	__property System::TDateTime notBefore = {read=RnotBefore};
	__property System::TDateTime notAfter = {read=RnotAfter};
};


class DELPHICLASS EIdOpenSSLError;
class PASCALIMPLEMENTATION EIdOpenSSLError : public Inexception::EInException 
{
	typedef Inexception::EInException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOpenSSLError(AnsiString AMsg)/* overload */ : Inexception::EInException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOpenSSLError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EInException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOpenSSLError(int Ident)/* overload */ : Inexception::EInException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOpenSSLError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EInException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOpenSSLError(const AnsiString Msg, int AHelpContext) : Inexception::EInException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOpenSSLError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EInException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOpenSSLError(int Ident, int AHelpContext)/* overload */ : Inexception::EInException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOpenSSLError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EInException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOpenSSLError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOpenSSLLoadError;
class PASCALIMPLEMENTATION EIdOpenSSLLoadError : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOpenSSLLoadError(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOpenSSLLoadError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOpenSSLLoadError(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOpenSSLLoadError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOpenSSLLoadError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOpenSSLLoadError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOpenSSLLoadError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOpenSSLLoadError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOpenSSLLoadError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLCouldNotLoadSSLLibrary;
class PASCALIMPLEMENTATION EIdOSSLCouldNotLoadSSLLibrary : public EIdOpenSSLLoadError 
{
	typedef EIdOpenSSLLoadError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLCouldNotLoadSSLLibrary(AnsiString AMsg)/* overload */ : EIdOpenSSLLoadError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLCouldNotLoadSSLLibrary(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLLoadError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLCouldNotLoadSSLLibrary(int Ident)/* overload */ : EIdOpenSSLLoadError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLCouldNotLoadSSLLibrary(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLLoadError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLCouldNotLoadSSLLibrary(const AnsiString Msg, int AHelpContext) : EIdOpenSSLLoadError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLCouldNotLoadSSLLibrary(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLLoadError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLCouldNotLoadSSLLibrary(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLCouldNotLoadSSLLibrary(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLCouldNotLoadSSLLibrary(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLModeNotSet;
class PASCALIMPLEMENTATION EIdOSSLModeNotSet : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLModeNotSet(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLModeNotSet(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLModeNotSet(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLModeNotSet(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLModeNotSet(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLModeNotSet(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLModeNotSet(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLModeNotSet(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLModeNotSet(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLGetMethodError;
class PASCALIMPLEMENTATION EIdOSSLGetMethodError : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLGetMethodError(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLGetMethodError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLGetMethodError(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLGetMethodError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLGetMethodError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLGetMethodError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLGetMethodError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLGetMethodError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLGetMethodError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLCreatingContextError;
class PASCALIMPLEMENTATION EIdOSSLCreatingContextError : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLCreatingContextError(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLCreatingContextError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLCreatingContextError(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLCreatingContextError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLCreatingContextError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLCreatingContextError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLCreatingContextError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLCreatingContextError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLCreatingContextError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLLoadingRootCertError;
class PASCALIMPLEMENTATION EIdOSSLLoadingRootCertError : public EIdOpenSSLLoadError 
{
	typedef EIdOpenSSLLoadError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLLoadingRootCertError(AnsiString AMsg)/* overload */ : EIdOpenSSLLoadError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLLoadingRootCertError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLLoadError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLLoadingRootCertError(int Ident)/* overload */ : EIdOpenSSLLoadError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLLoadingRootCertError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLLoadError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLLoadingRootCertError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLLoadError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLLoadingRootCertError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLLoadError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLLoadingRootCertError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLLoadingRootCertError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLLoadingRootCertError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLLoadingCertError;
class PASCALIMPLEMENTATION EIdOSSLLoadingCertError : public EIdOpenSSLLoadError 
{
	typedef EIdOpenSSLLoadError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLLoadingCertError(AnsiString AMsg)/* overload */ : EIdOpenSSLLoadError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLLoadingCertError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLLoadError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLLoadingCertError(int Ident)/* overload */ : EIdOpenSSLLoadError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLLoadingCertError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLLoadError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLLoadingCertError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLLoadError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLLoadingCertError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLLoadError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLLoadingCertError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLLoadingCertError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLLoadingCertError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLLoadingKeyError;
class PASCALIMPLEMENTATION EIdOSSLLoadingKeyError : public EIdOpenSSLLoadError 
{
	typedef EIdOpenSSLLoadError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLLoadingKeyError(AnsiString AMsg)/* overload */ : EIdOpenSSLLoadError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLLoadingKeyError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLLoadError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLLoadingKeyError(int Ident)/* overload */ : EIdOpenSSLLoadError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLLoadingKeyError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLLoadError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLLoadingKeyError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLLoadError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLLoadingKeyError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLLoadError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLLoadingKeyError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLLoadingKeyError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLLoadError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLLoadingKeyError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLSettingCipherError;
class PASCALIMPLEMENTATION EIdOSSLSettingCipherError : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLSettingCipherError(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLSettingCipherError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLSettingCipherError(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLSettingCipherError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLSettingCipherError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLSettingCipherError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLSettingCipherError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLSettingCipherError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLSettingCipherError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLDataBindingError;
class PASCALIMPLEMENTATION EIdOSSLDataBindingError : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLDataBindingError(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLDataBindingError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLDataBindingError(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLDataBindingError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLDataBindingError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLDataBindingError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLDataBindingError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLDataBindingError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLDataBindingError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLAcceptError;
class PASCALIMPLEMENTATION EIdOSSLAcceptError : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLAcceptError(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLAcceptError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLAcceptError(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLAcceptError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLAcceptError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLAcceptError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLAcceptError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLAcceptError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLAcceptError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdOSSLConnectError;
class PASCALIMPLEMENTATION EIdOSSLConnectError : public EIdOpenSSLError 
{
	typedef EIdOpenSSLError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdOSSLConnectError(AnsiString AMsg)/* overload */ : EIdOpenSSLError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdOSSLConnectError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EIdOpenSSLError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdOSSLConnectError(int Ident)/* overload */ : EIdOpenSSLError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdOSSLConnectError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EIdOpenSSLError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdOSSLConnectError(const AnsiString Msg, int AHelpContext) : EIdOpenSSLError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdOSSLConnectError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EIdOpenSSLError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdOSSLConnectError(int Ident, int AHelpContext)/* overload */ : EIdOpenSSLError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdOSSLConnectError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EIdOpenSSLError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdOSSLConnectError(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE int __cdecl PasswordCallback(char * buf, int size, int rwflag, void * userdata);
extern PACKAGE void __cdecl InfoCallback(void * sslSocket, int where, int ret);
extern PACKAGE bool __fastcall LogicalAnd(int A, int B);
extern PACKAGE int __cdecl VerifyCallback(int Ok, void * ctx);

}	/* namespace Insslopenssl */
using namespace Insslopenssl;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Insslopenssl
